<?php
/**
 * ------------------------------------------------------------------------
 * JA Sensei Template
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2018 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - Copyrighted Commercial Software
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites:  http://www.joomlart.com -  http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
*/
defined('_JEXEC') or die;
  $moduleTitle = $module->title;
  $moduleSub = $params->get('sub-heading');
?>

<div class="container">
	<div id="acm-features-<?php echo $module->id; ?>" class="acm-features style-4">
		<div class="features-content">
			<div class="row">
				<?php if($helper->get('img-features')) : ?>
				<div class="col-xs-12 col-md-6 pull-right">
					<div class="features-media ja-animate" data-animation="fadeIn" data-delay="1200">
						<img src="<?php echo $helper->get('img-features'); ?>" alt="<?php echo $moduleTitle; ?>"/>

						<!-- VIDEO ACTION -->
						<a id="resume" href="javascript:void(0);">
				      <span class="icon ion-ios-play" aria-hidden="true"></span>
				    </a>

				    <a id="pause" class="hidden" href="javascript:void(0);">
				      <span class="icon ion-ios-pause" aria-hidden="true"></span>
				    </a>
						<!-- // VIDEO ACTION -->

						<!-- VIDEO PLAY -->
					  <?php if($helper->get('video-features')):?>
					  <div class="video-action">
					    <div class="videoWrapper">
					      <div id="player"></div>
					    </div>
					  </div>
					  <?php endif;?>
					  <!-- // VIDEO PLAY -->
					</div>
				</div>
				<?php endif ; ?>

				<div class="col-xs-12 col-md-6 pull-left">
					<div class="features-item">
						<?php if($module->showtitle) : ?>
							<h3 class="module-title ja-animate" data-animation="move-from-left" data-delay="200">
								<?php echo $moduleTitle ?>
							</h3>
						<?php endif ; ?>

						<?php if ($moduleSub): ?>
							<div class="sub-heading ja-animate" data-animation="move-from-left" data-delay="400">
								<span><?php echo $moduleSub; ?></span>		
							</div>
						<?php endif; ?>
						
						<?php if($helper->get('description')) : ?>
							<div class="features-desc ja-animate" data-animation="move-from-left" data-delay="800"><?php echo $helper->get('description') ?></div>
						<?php endif ; ?>
						
						<?php if($helper->get('button')) : ?>
							<div class="action ja-animate" data-animation="move-from-left" data-delay="1200">
								<a class="btn btn-primary" href="<?php echo $helper->get('title-link'); ?>"><?php echo $helper->get('button') ?>
								</a>
							</div>
						<?php endif ; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>


<?php if($helper->get('video-features')):?>
<script>
  // This code loads the IFrame Player API code asynchronously.
  var tag = document.createElement('script');
  tag.src = "https://www.youtube.com/player_api";
  var firstScriptTag = document.getElementsByTagName('script')[0];
  firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

  // This function creates an <iframe> (and YouTube player)
  // after the API code downloads.
  var player;
  function onYouTubePlayerAPIReady() {
    player = new YT.Player('player', {
        height: '315',
        width: '560',
        videoId: '<?php echo $helper->get('video-features');?>',
        playerVars: {
            'showinfo': 0
        },
        events: {
          'onStateChange': onPlayerStateChange
        }
    });

    document.getElementById('resume').onclick = function() {
        player.playVideo();
        jQuery('#acm-features-<?php echo $module->id; ?>').addClass('play');
        jQuery(this).addClass('hidden');
        jQuery('#acm-features-<?php echo $module->id; ?> #pause').removeClass('hidden');
    };
    document.getElementById('pause').onclick = function() {
        player.pauseVideo();
        jQuery('#acm-features-<?php echo $module->id; ?>').removeClass('play');
        jQuery(this).addClass('hidden');
        jQuery('#acm-features-<?php echo $module->id; ?> #resume').removeClass('hidden');
    };
  }

  // when video ends
  function onPlayerStateChange(event) {        
      if(event.data === 0) {          
        jQuery('#acm-features-<?php echo $module->id; ?>').removeClass('play');
        jQuery('#pause').addClass('hidden');
        jQuery('#acm-features-<?php echo $module->id; ?> #resume').removeClass('hidden');
      }
  }
</script>
<?php endif;?>