<?php
/**
 * ------------------------------------------------------------------------
 * JA Sensei Template
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2018 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - Copyrighted Commercial Software
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites:  http://www.joomlart.com -  http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
*/
defined('_JEXEC') or die;
	$moduleTitle = $module->title;
  $moduleSub = $params->get('sub-heading');
	$count 					= $helper->getRows('data.name');
	$lang = JFactory::getLanguage();
  $dir = $lang->get('rtl');
?>

<div class="acm-testimonial style-1">
	<div class="container">
		<div class="testimonial-inner">
			<div class="module-title-wrap">
				<?php if($module->showtitle) : ?>
					<h3 class="module-title">
						<?php echo $moduleTitle ?>
					</h3>
				<?php endif ; ?>

				<?php if ($moduleSub): ?>
					<div class="sub-heading">
						<span><?php echo $moduleSub; ?></span>		
					</div>
				<?php endif; ?>
			</div>

			<div class="testimonial-content">
				<div id="acm-testimonial-<?php echo $module->id; ?>">
					<div class="owl-carousel owl-theme">
						<?php 
							for ($i=0; $i<$count; $i++) : 
						?>
							<div class="testimonial-item-wrap">
								<div class="testimonial-item-inner">
									<?php if($helper->get('data.img', $i)) : ?>
										<div class="testimonial-img">
											<img src="<?php echo $helper->get('data.img', $i) ?>" alt="" />
										</div>
									<?php endif ; ?>

									<?php if($helper->get('data.name', $i)) : ?>
										<h5 class="testimonial-name"><?php echo $helper->get('data.name', $i) ?></h5>
									<?php endif ; ?>
										
									<?php if($helper->get('data.member-position', $i)) : ?>
										<div class="testimonial-position"><?php echo $helper->get('data.member-position', $i) ?></div>
									<?php endif ; ?>

									<?php if($helper->get('data.member-description', $i)) : ?>
										<div class="lead"><?php echo $helper->get('data.member-description', $i) ?></div>
									<?php endif ; ?>
								</div>
							</div>
						<?php endfor ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
(function($){
  jQuery(document).ready(function($) {
    $("#acm-testimonial-<?php echo $module->id; ?> .owl-carousel").owlCarousel({
    	rtl:<?php echo($dir == 0) ? 'false' : 'true' ;?>,
      items: 1,
      center: true,
      margin: 200,
      dots: true,
      loop: true
    });
  });
})(jQuery);
</script>